class MM_DamageMutator extends Mutator;

var bool Init;

function PostBeginPlay()
{
	if (Init)
		return;
	Init = True;

	Level.Game.RegisterDamageMutator(Self);

	//log("MM-DamageMutator initialized.");
}

function MutatorTakeDamage( out int ActualDamage, Pawn Victim, Pawn InstigatedBy, out Vector HitLocation, out Vector Momentum, name DamageType)
{
local int MyDamage;
local float suckamount;
local vector Vect;
local MonsterPRI PRI;

     if (Victim != None && InstigatedBy != None && InstigatedBy != Victim)
     	{
		if ( Victim.IsA('Monsters') && InstigatedBy.IsA('Monsters') )
			ActualDamage = 0;

		if ( Victim.IsA('PlayerPawn') && MonsterPRI(PlayerPawn(Victim).PlayerReplicationInfo).ImunityTime > 0 )
			{
			ActualDamage = 0;
			}

		else if ( Victim.IsA('Pawn') )
			{
			if ( Victim.Health < ActualDamage )
				{
				MyDamage = Victim.Health;
				}
			else
				{
				MyDamage = ActualDamage;
				}
			if ( InstigatedBy.IsA('PlayerPawn') )
				{
				InstigatedBy.PlayerReplicationInfo.Score += 0.2 * MyDamage;
				PRI = MonsterPRI(InstigatedBy.PlayerReplicationInfo);
				if ( PRI != none )
					{
					if ( PRI.VampireTime > 0 )
						{
						suckamount = float(PRI.VampirePercentage) / 100;
						InstigatedBy.Health += ActualDamage * suckamount;
						if ( InstigatedBy.Health > PRI.MaxPlayerHealth )
							InstigatedBy.Health = PRI.MaxPlayerHealth;
						}
					}
				}
			else if ( InstigatedBy.IsA('Bot') )
				InstigatedBy.PlayerReplicationInfo.Score += 0.2 * MyDamage;
			}
    	 }

	if ( NextDamageMutator != None )
     		NextDamageMutator.MutatorTakeDamage( ActualDamage, Victim, InstigatedBy, HitLocation, Momentum, DamageType);	
}

defaultproperties
{	
}

